// Generating the DFT function

function X=dft(x,N)  
    L=length(x);
    if(L>N)
        disp('error because  L should be less than N');
    end
    x1=[x zeros(1,N-L)];   // zero padding the sequence x(n)
    for k=0:1:N-1
        for n=0:1:N-1
            p=exp(-%i*2*%pi*k*n/N);
            x2(k+1,n+1)=p;
        end
    end
    X=x1*x2;
endfunction
